<!doctype html>
<html lang="en">
   <head>
      <meta charset="utf-8">
      <meta name="viewport" content="width=device-width, initial-scale=1">
      <title>Accounts Ledgers</title>
      <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-9ndCyUaIbzAi2FUVXJi0CjmCapSmO7SnpJef0486qhLnuZ2cdeRhO02iuK6FUUVM" crossorigin="anonymous">
            <style>
         body,html{
         height:100%;
         font-family: "Lucida Console", Courier, monospace;
         }
      </style>
   </head>
   <body>
      
         <div class="container h-100">
         <div class="row h-100 justify-content-center align-items-center">
            <div class="col-md-7">
               <div class="card">
                  <div class="card-header">
                     Account Ledger
                  </div>
                  <div class="card-body">
                     <form action="<?php echo e(url('/')); ?>/report/ledger" method="post">
                        <?php echo csrf_field(); ?>
                        <!-- project name -->
                        <div class="form-group row">
                           <label for="inputPassword" class="col-sm-3 col-form-label  mt-2">Project ID</label>
                           <div class="col-sm-9">
                              <input class="form-control rounded-0" type="text" name="projectid" id="projectid">
                           </div>
                        </div>
                        <div class="form-group row mt-2">
                           <label for="inputPassword" class="col-sm-3 col-form-label">Project Name</label>
                           <div class="col-sm-9">
                              <select class="form-control rounded-0 " id="project_name" name="project_name">
                                 <?php $__currentLoopData = $projectdata; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                 <option data-id="<?php echo e($data->id); ?>" value="<?php echo e($data->project_name); ?>"><?php echo e($data->project_name); ?></option>
                                 <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                              </select>
                           </div>
                        </div>
                        <div class="form-group row mt-2">
                           <label for="inputPassword" class="col-sm-3 col-form-label">Header ID</label>
                           <div class="col-sm-9">
                              <input type="text" id="headercode"  name="headercode" class="form-control rounded-0" placeholder="Header Code">
                           </div>
                        </div>
                        <div class="form-group row mt-2">
                           <label for="inputPassword" class="col-sm-3 col-form-label">Account ID</label>
                           <div class="col-sm-9">
                              <input type="text" id="accountid" name="accountid" class="form-control rounded-0" placeholder="Account ID">
                           </div>
                        </div>
                        <div class="form-group row mt-2">
                           <label for="inputPassword" class="col-sm-3 col-form-label">Account Name</label>
                           <div class="col-sm-9">
                              <select class="form-control rounded-0" id="account_name" name="account_name"> </select>
                              
                              <span class="text-danger">
                                 <?php $__errorArgs = ['accountid'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                 <p>Please select your Account</p>
                                 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                              </span>
                           </div>
                        </div>
                        <div class="form-group row mt-2">
                           <label for="inputPassword" class="col-sm-3 col-form-label">Start Date</label>
                           <div class="col-sm-9">
                              <input type="date" class="form-control rounded-0" id="date_print"
                                 value="<?php echo e($search ?? now()->format('Y-m-d')); ?>" name="start_date" placeholder="Start Date">
                           </div>
                        </div>
                        <div class="form-group row mt-2">
                           <label for="inputPassword" class="col-sm-3 col-form-label  mt-2">End Date</label>
                           <div class="col-sm-9">
                              <input type="date" class="form-control rounded-0 " id="date_print"
                                 value="<?php echo e($search ?? now()->format('Y-m-d')); ?>" name="end_date" placeholder="End Date">
                           </div>
                        </div>
                        <div class="d-grid mt-3 d-md-flex justify-content-md-end">
                           <button type="submit" class="btn btn-success mt-2 align-right">Print View</button>
                        </div>
                  </div>

                  </form>
               </div>
            </div>
         </div>
      </div>
      </div>
      </div>  
      </form>
      <!-- jQuery CDN - Slim version (=without AJAX) -->
      <script src="https://code.jquery.com/jquery-3.6.4.min.js" integrity="sha256-oP6HI9z1XaZNBrJURtCoUT5SUnxFr8s3BzRl+cbzUq8=" crossorigin="anonymous"></script>
      <!-- Popper.JS -->
      <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.0/umd/popper.min.js" integrity="sha384-cs/chFZiN24E4KMATLdqdvsezGxaGsi4hLGOzlXwp5UZB1LY//20VyM2taTB4QvJ" crossorigin="anonymous"></script>
      <!-- Bootstrap JS -->
      <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.1.0/js/bootstrap.min.js" integrity="sha384-uefMccjFJAIv6A+rW+L4AHf99KvxDjWSu1z9VI8SKNVmz4sk7buKt/6v9KI65qnm" crossorigin="anonymous"></script>
      <script>
         $('#project_name').change(function(){
         
           var selected = $(this).find('option:selected');    
            var projectid = selected.data('id');
            $('#projectid').val( projectid );
         
         
             //append into account dropdown start here
         var pid=jQuery(this).val();
               $.ajax({
                   url: '<?php echo e(route("Cvoucher.accounts")); ?>',
                   type: 'POST',
                   data: 'projectid='+projectid+'&_token=<?php echo e(csrf_token()); ?>',
         
                   success:function(result){
                       $('#account_name').html('<option value="">Select Your Account</option>');
                           $.each(result.accounts, function (key, value) {
                               
                               $("#account_name").append('<option data-headercode="' + value.header_code + '" data-accountid="' + value.id + '" value="' + value.customer_name + '">' + value.customer_name  + '</option>');
                           });
         
         
                   }
               });
           //end 
         
         });
         
         
         $('#account_name').change(function(){
         var selected = $(this).find('option:selected');
         var headercode = selected.data('headercode');
         var selected = $(this).find('option:selected');
         var accountid = selected.data('accountid');
         var selected = $(this).find('option:selected');
         
         
         
         $('#headercode').val( headercode );
         $('#accountid').val( accountid );
         
         alert($accountid);
         
         
         });
         
      </script>
   </body>
</html><?php /**PATH /home/imtiazir/public_html/resources/views/reports/ledgerview.blade.php ENDPATH**/ ?>