<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8" />
    <title>Trial Balance</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .group-header { background: #f1f7ff; font-weight: 700; }
        .account-row td:first-child { padding-left: 1.25rem; }

        /* Page setup for printing */
        @page {
            size: A4;
            margin: 0;
        }

        @media print {
            body, html {
                padding: 0px;
                font-size: 13px;
                line-height: 1.0;
            }

            /* Hide filters and buttons */
            .d-print-none { display: none !important; }

            /* Force side-by-side columns on print */
            .row.print-row {
                display: flex !important;
                flex-wrap: nowrap !important;
            }
            .row.print-row > .col-md-6 {
                flex: 0 0 50% !important;
                max-width: 50% !important;
            }
        }
    </style>
</head>
<body>
<div class="container-fluid my-3">

    <!-- Print Button -->
    <button onclick="window.print()" class="btn btn-primary d-print-none mb-3">
        🖨 Print
    </button>

    <!-- Filter Form -->
    <form method="GET" action="<?php echo e(route('reports.trailbalance')); ?>" class="row g-3 mb-4 d-print-none">
        <div class="col-md-3">
            <label class="form-label">Start Date</label>
            <input type="date" name="start_date" value="<?php echo e(request('start_date')); ?>" class="form-control">
        </div>
        <div class="col-md-3">
            <label class="form-label">End Date</label>
            <input type="date" name="end_date" value="<?php echo e(request('end_date')); ?>" class="form-control">
        </div>
        <div class="col-md-4">
            <label class="form-label">Project</label>
            <select name="project_id" class="form-select">
                <option value="">-- All Projects --</option>
                <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($p->ProjectID); ?>" <?php echo e(request('project_id') == $p->ProjectID ? 'selected' : ''); ?>>
                        <?php echo e($p->ProjectName); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
        <div class="col-md-2 d-grid">
            <button class="btn btn-primary">Filter</button>
        </div>
    </form>

    <!-- Page Header -->
    <h4 class="mb-3">Trial Balance
        <?php if($start_date && $end_date): ?>
            <small class="text-muted">(<?php echo e($start_date); ?> to <?php echo e($end_date); ?>)</small>
        <?php endif; ?>
        <?php if($selectedProject): ?>
            <br><small class="text-muted">Project: <?php echo e($selectedProject->ProjectName); ?></small>
        <?php endif; ?>
    </h4>

    <!-- Debit & Credit Tables Side by Side -->
    <div class="row print-row">
        <!-- Debit Column -->
        <div class="col-md-6">
            <h5>Debit</h5>
            <table class="table table-sm table-bordered">
                <thead class="table-light">
                    <tr>
                        <th>Account Type</th>
                        <th>Account Name</th>
                        <th class="text-end">Amount</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $debitsGrouped; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type => $accounts): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="group-header"><td colspan="2"><?php echo e($type); ?></td></tr>
                        <?php $__currentLoopData = $accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $acc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="account-row">
                                <td colspan="2"><?php echo e($acc->account_name); ?></td>
                                <td class="text-end"><?php echo e(number_format($acc->amount, 2)); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <tr class="group-header">
                            <td colspan="2" class="text-end">Total Of <?php echo e($type); ?></td>
                            <td class="text-end"><?php echo e(number_format($debitsGroupTotals[$type] ?? 0, 2)); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr><td colspan="3" class="text-center text-muted">No debit rows</td></tr>
                    <?php endif; ?>
                </tbody>
                <tfoot>
                    <tr class="table-secondary fw-bold">
                        <td colspan="2">Grand Total Debit</td>
                        <td class="text-end"><?php echo e(number_format($grandDebit, 2)); ?></td>
                    </tr>
                </tfoot>
            </table>
        </div>

        <!-- Credit Column -->
        <div class="col-md-6">
            <h5>Credit</h5>
            <table class="table table-sm table-bordered">
                <thead class="table-light">
                    <tr>
                        <th>Account Type</th>
                        <th>Account Name</th>
                        <th class="text-end">Amount</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $creditsGrouped; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type => $accounts): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="group-header"><td colspan="2"><?php echo e($type); ?></td></tr>
                        <?php $__currentLoopData = $accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $acc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="account-row">
                                <td colspan="2"><?php echo e($acc->account_name); ?></td>
                                <td class="text-end"><?php echo e(number_format($acc->amount, 2)); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <tr class="group-header">
                            <td colspan="2" class="text-end">Total Of <?php echo e($type); ?></td>
                            <td class="text-end"><?php echo e(number_format($creditsGroupTotals[$type] ?? 0, 2)); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr><td colspan="3" class="text-center text-muted">No credit rows</td></tr>
                    <?php endif; ?>
                </tbody>
                <tfoot>
                    <tr class="table-secondary fw-bold">
                        <td colspan="2">Grand Total Credit</td>
                        <td class="text-end"><?php echo e(number_format($grandCredit, 2)); ?></td>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>

    <!-- Difference -->
    <div class="mt-3">
        <h5>
            Difference (Credit - Debit):
            <span class="<?php echo e($difference < 0 ? 'text-danger' : 'text-success'); ?>">
                <?php echo e(number_format($difference, 2)); ?>

            </span>
        </h5>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<?php /**PATH /home/alameenb/public_html/resources/views/reports/DateWiseTrailbalance.blade.php ENDPATH**/ ?>