<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Trial Balance Report</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { font-size: 14px; }
        .report-title { font-size: 20px; font-weight: bold; margin-bottom: 20px; text-align: center; }
        .table th, .table td { vertical-align: middle; }
        .table tfoot td { font-weight: bold; }
    </style>
</head>
<body class="p-4">

    <div class="report-title">
        Trial Balance Report
        <?php if($startDate && $endDate): ?>
            <div class="text-muted" style="font-size: 14px;">
                Period: <?php echo e($startDate); ?> to <?php echo e($endDate); ?>

            </div>
        <?php endif; ?>
    </div>

    <!-- Filters -->
    <form method="GET" action="<?php echo e(route('reports.jvBalance')); ?>" class="row g-3 mb-4">
        <div class="col-md-3">
            <label class="form-label">Start Date</label>
            <input type="date" name="start_date" value="<?php echo e($startDate); ?>" class="form-control">
        </div>
        <div class="col-md-3">
            <label class="form-label">End Date</label>
            <input type="date" name="end_date" value="<?php echo e($endDate); ?>" class="form-control">
        </div>
        <div class="col-md-3">
            <label class="form-label">Project</label>
            <select name="project_id" class="form-select">
                <option value="">All Projects</option>
                <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($p->project_id); ?>" <?php echo e($projectId == $p->project_id ? 'selected' : ''); ?>>
                        <?php echo e($p->project_name); ?> (<?php echo e($p->project_id); ?>)
                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
        <div class="col-md-2 align-self-end">
            <button class="btn btn-primary w-100">Filter</button>
        </div>
    </form>

    <!-- Table -->
    <table class="table table-bordered text-center">
        <thead class="table-dark">
            <tr>
                <th>Header Code</th>
                <th>Account Name</th>
                <th>Project</th>
                <th class="text-end">Debit (Dr)</th>
                <th class="text-end">Credit (Cr)</th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $records; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><?php echo e($row->header_code); ?></td>
                    <td class="text-start"><?php echo e($row->account_name); ?></td>
                    <td><?php echo e($row->project_name); ?></td>
                    <td class="text-end"><?php echo e(number_format($row->total_debit, 2)); ?></td>
                    <td class="text-end"><?php echo e(number_format($row->total_credit, 2)); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="5" class="text-center text-muted">No records found</td>
                </tr>
            <?php endif; ?>
        </tbody>
        <tfoot>
            <tr>
                <td colspan="3" class="text-end">Grand Total:</td>
                <td class="text-end"><?php echo e(number_format($grandDebit, 2)); ?></td>
                <td class="text-end"><?php echo e(number_format($grandCredit, 2)); ?></td>
            </tr>
        </tfoot>
    </table>

</body>
</html>
<?php /**PATH /home/alameenb/public_html/resources/views/reports/jv_balance.blade.php ENDPATH**/ ?>