<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-KK94CHFLLe+nY2dmCWGMq91rCGa5gtU4mk92HdvYe+M/SXH301p5ILy+dN9+nJOZ" crossorigin="anonymous">

    <title>Provisional Receipt</title>
    <style>

@media print {
    
  @page { margin: 0; }
  body { margin: 1.6cm; }
  #noprint {display: none;}

}
#alignr{
    text-align:right;
}
#alignc{
    text-align:center;
}
    </style>
</head>
<body>
    <center>
        <button class="btn btn-warning btn-sm" id="noprint" onclick="window.print()">Print this page</button>
        <a href="/" id="noprint" class="btn btn-danger btn-sm">Back</a>
        </center>
    <div class="container-fluid">
     
            <div class="row">
                <div class="col-6">
                <h1 ><?php echo e($record->project_name); ?></h1>
                </div>
                <div class="col-6 pt-3 ">
                <p id="alignr"><small>Print By: <?php echo e(session('user_name')); ?> - <?php echo e(now()); ?></small></p>
                    
                </div>
                
            </div>
            
<h6><i>Provisional Receipt</i></h6>
            <hr>
            <div class="row">
                    <div class="col-3 ">
                    <h7 >Receipt No# :</h7>
                    </div>
                    <div class="col-3">
                    <h7 ><?php echo e($record->id); ?></h7>
                    </div>   

                    <div class="col-3 ">
                    <h7 >Date  : </h7>
                    </div>    
                    <div class="col-3 ">
                    <h7 ><?php echo e(date('d-M-y', strtotime($record->date))); ?></h7>
                    </div>                                   
            </div>
            <div class="row">
                <div class="col-3">
                <h7 >Project id : </h7>
                </div>
                <div class="col-3">
                <h7 ><?php echo e($record->project_id); ?></h7>
                </div>                
                <div class="col-3">
                <h7 >Account ID  : </h7>
                </div>     
                <div class="col-3">
                <h7 ><?php echo e($record->header_code); ?>-<?php echo e($record->account_id); ?></h7>
                </div>                              
            </div>       
            <div class="row">
                <div class="col-3">
                <h7 >Project Name :</h7>
                </div>
                <div class="col-3">
                <h7 ><?php echo e($record->project_name); ?></h7>
                </div>                
                <div class="col-3">
                <h7 >Account Name  : </h7>
                </div>      
                <div class="col-3">
                <h7 ><?php echo e($record->account_name); ?></h7>
                </div>                              
            </div>        
</br>
<table class="table">
    <th>Date</th>
    <th>Bank</th>
    <th>Cheque No</th>
    <th>Amount</th>
    
    
    <?php $__currentLoopData = $records; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rec): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        
        <tr>
            <td><?php echo e(date('d-M-y', strtotime($rec->cheque_date))); ?></td>
            <td><?php echo e($rec->bank_name); ?></td>
            <td><?php echo e($rec->cheque_no); ?></td>
            <?php if($rec->dr == 0): ?> 
            <td><b><?php echo e(number_format($rec->cr,0)); ?></b></td>
            <?php else: ?>
            <td><b><?php echo e(number_format($rec->dr,0)); ?></b></td>
            <?php endif; ?>
        </tr>
        
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</table>            
            <div class="row mt-5">
                <div class="col-6">
                <h5 class="text-center">Received By </h5>
                <p class="text-center">Accountant - <span class="text-muted"><?php echo e(session('user_name')); ?></span></p>
                <hr>
                </div>
                <div class="col-6">
                <h5 class="text-center">Description </h5>
                <p class="text-center"><span class="text-muted"><?php echo e($record->description); ?></span></p>
                <hr>
                </div>
                
                </div>
            </div>       
           
 
                  
            </div>  

 
        
    </div>
    
</body>
</html><?php /**PATH /home/alameenb/public_html/resources/views/cheques/show.blade.php ENDPATH**/ ?>