<!doctype html>
<html lang="en">
   <head>
      <meta charset="utf-8">
      <meta name="viewport" content="width=device-width, initial-scale=1">
      <title>Accounts Ledgers</title>
      <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-9ndCyUaIbzAi2FUVXJi0CjmCapSmO7SnpJef0486qhLnuZ2cdeRhO02iuK6FUUVM" crossorigin="anonymous">
            <style>
         body,html{
         height:100%;
         font-family: "Lucida Console", Courier, monospace;
         }
      </style>
   </head>
   <body>
       
      
         <div class="container h-100">
         <div class="row h-100 justify-content-center align-items-center">
            <div class="col-md-7">
               <div class="card">
                  <div class="card-header">
                     Account Ledger
                  </div>
                  <div class="card-body">
                     <form action="<?php echo e(url('/')); ?>/report/ledger" method="post">
                        <?php echo csrf_field(); ?>
                        <!-- project name -->
                        <div class="form-group row">
                           <label for="inputPassword" class="col-sm-3 col-form-label  mt-2">Project ID</label>
                           <div class="col-sm-9">
                              <input class="form-control rounded-0" type="text" name="projectid" id="projectid">
                           </div>
                        </div>
                        <div class="form-group row mt-2">
                           <label for="inputPassword" class="col-sm-3 col-form-label">Project Name</label>
                           <div class="col-sm-9">
                              <select class="form-control rounded-0 " id="project_name" name="project_name">
                                  <option>Select Your Project</option>
                                 <?php $__currentLoopData = $projectdata; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                 <option data-id="<?php echo e($data->id); ?>" value="<?php echo e($data->project_name); ?>"><?php echo e($data->project_name); ?></option>
                                 <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                              </select>
                           </div>
                        </div>

                        <div class="form-group row mt-2">
                           <label for="inputPassword" class="col-sm-3 col-form-label">Unit No</label>
                           <div class="col-sm-9">
                              <input list="unit_no_options" id="unit_no" name="unit_no" autocomplete="off" class="form-control ">
                                <datalist id="unit_no_options"> </datalist> 
                           </div>
                        </div>                        

                        

                        
                        <div class="form-group row mt-2">
                           <label for="inputPassword" class="col-sm-3 col-form-label">Header ID</label>
                           <div class="col-sm-9">
                              <input type="text" id="headercode"  name="headercode" class="form-control rounded-0" placeholder="Header Code">
                           </div>
                        </div>
                        <div class="form-group row mt-2">
                           <label for="inputPassword" class="col-sm-3 col-form-label">Account ID</label>
                           <div class="col-sm-9">
                              <input type="text" id="accountid" name="accountid" class="form-control rounded-0" placeholder="Account ID">
                           </div>
                        </div>
                        <div class="form-group row mt-2">
                           <label for="inputPassword" class="col-sm-3 col-form-label">Account Name</label>
                           <div class="col-sm-9">
                                <input list="account_name_options" id="account_name" name="account_name" autocomplete="off" class="form-control">
                        
                                <datalist id="account_name_options">

                        </datalist>
                           </div>
                        </div>
                        <div class="form-group row mt-2">
                           <label for="inputPassword" class="col-sm-3 col-form-label">Start Date</label>
                           <div class="col-sm-9">
                              <input type="date" class="form-control rounded-0" id="date_print"
                                 value="<?php echo e($search ??  $newDateTime->format('Y-m-d')); ?>" name="start_date" placeholder="Start Date">
                           </div>
                        </div>
                        <div class="form-group row mt-2">
                           <label for="inputPassword" class="col-sm-3 col-form-label  mt-2">End Date</label>
                           <div class="col-sm-9">
                              <input type="date" class="form-control rounded-0 " id="date_print"
                                 value="<?php echo e($search ?? now()->format('Y-m-d')); ?>" name="end_date" placeholder="End Date">
                           </div>
                        </div>
                        <div class="d-grid mt-3 d-md-flex justify-content-md-end">
                           <button type="submit" class="btn btn-success mt-2 align-right">Print View</button>
                        </div>
                  </div>

                  </form>
               </div>
            </div>
         </div>
      </div>
      </div>
      </div>  
      </form>
      <!-- jQuery CDN - Slim version (=without AJAX) -->
      <script src="https://code.jquery.com/jquery-3.6.4.min.js" integrity="sha256-oP6HI9z1XaZNBrJURtCoUT5SUnxFr8s3BzRl+cbzUq8=" crossorigin="anonymous"></script>
      <!-- Popper.JS -->
      <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.0/umd/popper.min.js" integrity="sha384-cs/chFZiN24E4KMATLdqdvsezGxaGsi4hLGOzlXwp5UZB1LY//20VyM2taTB4QvJ" crossorigin="anonymous"></script>
      <!-- Bootstrap JS -->
      <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.1.0/js/bootstrap.min.js" integrity="sha384-uefMccjFJAIv6A+rW+L4AHf99KvxDjWSu1z9VI8SKNVmz4sk7buKt/6v9KI65qnm" crossorigin="anonymous"></script>
      <script>
      
$('document').ready(function(){

    var cookiesArray = document.cookie.split(";");

    for (var i=0; i< cookiesArray.length; i++){
	var valueArray = cookiesArray[i].split("=");
	 
	    
        if(valueArray[0].trim() == 'id'){
        	var projectid = valueArray[1];
    	}
    	
    	if(valueArray[0].trim() == 'acc_name'){
        	var acc_name = valueArray[1];
        	
        	if($('#projectid').val() > 0 ){
        	$('#account_name').val( acc_name );    
        	}
    	}
            	
        
    }
    

console.log(document.cookie);

    $.ajax({
                url: '<?php echo e(route("Cvoucher.customers")); ?>',
                type: 'POST',
                data: 'projectid='+projectid+'&_token=<?php echo e(csrf_token()); ?>',

    
                success:function(result){
                       
                       
                        $.each(result.accounts, function (key, value) {
                            $("#unit_no_options").append('<option data-account_name=" ' + value.customer_name + '" data-category=" ' + value.category + '" data-headercode="' + value.header_code + '" data-accountid="' + value.id + '" value="' + value.unit_no + '">' +  value.unit_no  +  '</option>');
                        });                        
                        

                }

            });
    
    //load all accounts    
    $.ajax({
                   url: '<?php echo e(route("Cvoucher.accounts")); ?>',
                   type: 'POST',
                   data: 'projectid='+projectid+'&_token=<?php echo e(csrf_token()); ?>',
         
                   success:function(result){
                       
                       
                       
                           $.each(result.accounts, function (key, value) {
                               
                               $("#account_name_options").append('<option  data-unit_no=" ' + value.unit_no + '" data-headercode="' + value.header_code + '" data-accountid="' + value.id + '" value="' + value.customer_name + '">' + value.customer_name + ' ' + value.unit_no  + '</option>');
                           });
         
         
                   }
               });
           //end 
        
            
    $('#project_name').change(function(){
             
       
         
           var selected = $(this).find('option:selected');    
            var projectid = selected.data('id');
            $('#projectid').val( projectid );
            
            document.cookie = "id=" + projectid;
          

             //append into account dropdown start here
         var pid=jQuery(this).val();
         
         
         //load all unit no
          $("#unit_no_options").empty();
         $.ajax({
                url: '<?php echo e(route("Cvoucher.customers")); ?>',
                type: 'POST',
                data: 'projectid='+projectid+'&_token=<?php echo e(csrf_token()); ?>',

    
                success:function(result){
                       
                       
                        $.each(result.accounts, function (key, value) {
                            $("#unit_no_options").append('<option data-account_name=" ' + value.customer_name + '" data-category=" ' + value.category + '" data-headercode="' + value.header_code + '" data-accountid="' + value.id + '" value="' + value.unit_no + '">' +  value.unit_no  +  '</option>');
                        });                        


                }

            });   
            
    
        $("#account_name_options").empty();

        //load all accounts    
         $.ajax({
                   url: '<?php echo e(route("Cvoucher.accounts")); ?>',
                   type: 'POST',
                   data: 'projectid='+projectid+'&_token=<?php echo e(csrf_token()); ?>',
         
                   success:function(result){
                       
                           $.each(result.accounts, function (key, value) {
                               
                               $("#account_name_options").append('<option data-unit_no=" ' + value.unit_no + '" data-headercode="' + value.header_code + '" data-accountid="' + value.id + '" value="' + value.customer_name + '">' + value.customer_name + ' ' + value.id  + '</option>');
                           });
         
         
                   }
               });
           //end 
         
         });
    $('#account_name').change(function(){

    var value = $('#account_name').val();
    document.cookie = "acc_name=" + value;
    accountid = $('#account_name_options [value="' + value + '"]').data('accountid');
    headercode = $('#account_name_options [value="' + value + '"]').data('headercode');
    unit_no = $('#account_name_options [value="' + value + '"]').data('unit_no');
    
    
    

    $('#headercode').val( headercode );
    $('#accountid').val( accountid );
    $('#unit_no').val( unit_no );
    //alert(headercode + accountid);
         
         
         });
    $("#unit_no").on('change', function () {
    
    var value = $('#unit_no').val();
    accountid = $('#unit_no_options [value="' + value + '"]').data('accountid');
    headercode = $('#unit_no_options [value="' + value + '"]').data('headercode');
    category = $('#unit_no_options [value="' + value + '"]').data('category');
    account_name = $('#unit_no_options [value="' + value + '"]').data('account_name');
    
    $('#accountid').val( accountid );
    $('#headercode').val( headercode );
    $('#category').val( category );
    $('#account_name').val( account_name );
    
});
         

});
    </script>
</body>
</html><?php /**PATH /home/alameenb/public_html/resources/views/reports/ledgerview.blade.php ENDPATH**/ ?>