<!DOCTYPE html>
<html lang="en">
   <head>
      <meta charset="UTF-8">
      <meta http-equiv="X-UA-Compatible" content="IE=edge">
      <meta name="viewport" content="width=device-width, initial-scale=1.0">
      <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-KK94CHFLLe+nY2dmCWGMq91rCGa5gtU4mk92HdvYe+M/SXH301p5ILy+dN9+nJOZ" crossorigin="anonymous">
      <title>Account Ledger</title>
      <style>
         @media print {
             
            @page {
                size: A4;
                margin:auto;
                 /* change the margins as you want them to be. */
            }

            body{
                 font-family: Arial;
            }
         }
         

         

      </style>
   </head>
   <body>
       
       

      
      <div class="container-fluid">
         <div class="row g-1 mt-3">
            <div class="col-6">
                
                <h2>ACCOUNT LEDGER</h2>    
                <h6>Start Date:- <?php echo e(date('d-M-Y', strtotime($start_date))); ?></h6>
                <h6>End&nbsp;&nbsp; Date:- <?php echo e(date('d-M-Y', strtotime($end_date))); ?></h6>
                
            </div>
            <div class="col-6 text-end">
                         <h2><?php echo e($projectname); ?></h2>
         <h5><?php echo e($accountname); ?></h5>
         <h5><?php echo e($unit_no); ?></h5>
            </div>
            <small><?php echo "Printed:- " . date("d-M-y h:i:sa");?></small></br>

         <div class="col-12 text-end mt-2">
        </div>   
            <h6 class="text-end">Opening Balance <?php echo e(number_format($openingbal,0)); ?></h6>

               </div>
         <?php 
            $running_dr = 0;
            $running_cr = 0;
            $total = 0;
            $cost=0;
            ?>
            
              <?php if($headercode == 101): ?>
              <?php 
              $cost =$TotalCost->total_cost;
              ?>
              <?php endif; ?>
              <div class="table-responsive">
         <table class="table table-sm">
            <thead>
               <tr>
                  <th scope="col">Date</th>
                  <th scope="col">Description</th>
                  <th scope="col">Folio</th>
                  <th scope="col"  class="text-end">Debit</th>
                  <th scope="col"  class="text-end">Credit</th>
                  <th scope="col"  class="text-end">Balance</th>
               </tr>
            </thead>
            <tbody>
                 <?php if($headercode == 101): ?>
                <tr>
                    <td><?php echo e(date('d-M-y', strtotime($DateBooking->date_of_booking))); ?></td>
                    <td>Total Cost</td>
                    <td></td>
                    <td class="text-end">
                       
                        <?php echo e(number_format($cost,0)); ?>

                       
                     </td>
                     <td></td>
                     <td class="text-end">
                       
                        <?php echo e(number_format($cost,0)); ?>

                       
                     </td>
                </tr>
                <?php endif; ?>
               <?php $__currentLoopData = $voucherdata; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $datas): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
               <tr>
                  <td><?php echo e(date('d-M-y', strtotime($datas->date))); ?></td>
                  <td><?php echo e($datas->Description); ?></td>
                  <td><?php echo e($datas->id); ?></td>
                  <td class="text-end"><?php echo e(number_format($datas->debit,0)); ?></td>
                  <td  class="text-end"><?php echo e(number_format($datas->credit,0)); ?></td>
                  <?php 
                     $running_cr += $datas['credit'] ;
                     $running_dr += $datas['debit'];
                     ?>
                     <td  class="text-end">
                         <?php echo e(($openingbal+$cost+$running_dr)-($running_cr)); ?>

                     </td>
               </tr>
               <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
               <tr>
                  
                  <td></td>
                  <td></td>
                  <td></td>
                  <td  class="text-end"><b><?php echo e(number_format($running_dr+$cost,0)); ?></td>
                  <td  class="text-end"><b><?php echo e(number_format($running_cr,0)); ?></td>
                 <td  class="text-end"><b><?php echo e(number_format(($cost+$running_dr)-($running_cr),0)); ?></td>
               </tr>
            </tbody>
      </div>
      </table>
</div>

            <!-- jQuery CDN - Slim version (=without AJAX) -->
        <script src="https://code.jquery.com/jquery-3.6.4.min.js" integrity="sha256-oP6HI9z1XaZNBrJURtCoUT5SUnxFr8s3BzRl+cbzUq8=" crossorigin="anonymous"></script>
        <!-- Popper.JS -->
        <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.0/umd/popper.min.js" integrity="sha384-cs/chFZiN24E4KMATLdqdvsezGxaGsi4hLGOzlXwp5UZB1LY//20VyM2taTB4QvJ" crossorigin="anonymous"></script>
        <!-- Bootstrap JS -->
        <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.1.0/js/bootstrap.min.js" integrity="sha384-uefMccjFJAIv6A+rW+L4AHf99KvxDjWSu1z9VI8SKNVmz4sk7buKt/6v9KI65qnm" crossorigin="anonymous"></script>

      <script>
         $('#project_name').change(function(){
         
           var selected = $(this).find('option:selected');    
            var projectid = selected.data('id');
            $('#projectid').val( projectid );
         
         });
         
      </script>
   </body>
</html><?php /**PATH /home/tahakash/public_html/resources/views/reports/ledger.blade.php ENDPATH**/ ?>