<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/3.5.0/select2.min.css" rel="stylesheet"/>
    <link href="https://cdn.jsdelivr.net/npm/toastify-js/src/toastify.min.css" rel="stylesheet" />

    <title>Edit PURCHASE INVOICE</title> 

    <style>


    .select2-container .select2-choice {
        height:40px;
        line-height:33px;
    }
        #multiWrapper {
          width: 300px;
          margin: 0px 0 0 0px;
        }
    .def-cursor {
      cursor: default;
    }
    .form-unit .select2-container, .form-unit .select2-selection {
        width: 100% !important;
    }
    </style>
    
</head>

<body>
<div class="container">
    <form name="sample" id="invoice">
    <div class="row">
        <div class="col-6 pt-2 pb-2 bg-danger text-white">Edit Purchase Invoice</div>
        <div class="col-6 pt-2 pb-2 bg-danger text-white text-end">Last Updated <?php echo e($record->updated_at); ?></div>
    </div>    
    <div class="row pt-2 bg-light text-dark">
        <div class="col-6">

    <div class="row mb-3">
      <label for="colFormLabelSm" class="col-sm-3 col-form-label col-form-label-sm">Project Name</label>
      <input type="hidden" id="project_id" name="project_id" value="<?php echo e($record->project_id); ?>">
      <div class="col-sm-7">
        <input list="project_name_options" id="project_name" name="project_name" placeholder="Project Name" autocomplete="off" class="form-control form-control-sm" value="<?php echo e($record->project_name); ?>">
        <datalist id="project_name_options">
            <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option data-id="<?php echo e($data->id); ?>" value="<?php echo e($data->project_name); ?>"> 
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </datalist>
      </div>
    </div>
    <div class="row mb-3">
      <label for="colFormLabelSm" class="col-sm-3 col-form-label col-form-label-sm">Header code</label>
      <div class="col-sm-7">
        <input type="text" class="form-control form-control-sm" id="header_code" name="header_code" placeholder="Header Code" value="<?php echo e($record->header_code); ?>">
      </div>
    </div>
    <div class="row mb-3">
      <label for="colFormLabelSm" class="col-sm-3 col-form-label col-form-label-sm">Account Id</label>
      <div class="col-sm-7">
        <input type="text" class="form-control form-control-sm" id="account_id" name="account_id" placeholder="Account Id" value="<?php echo e($record->account_id); ?>">
      </div>
    </div>
    <div class="row mb-3">
      <label for="colFormLabelSm" class="col-sm-3 col-form-label col-form-label-sm">Account Name</label>
      <div class="col-sm-7">
        <input list="account_name_options" id="account_name" name="account_name" placeholder="Account Name" autocomplete="off" class="form-control form-control-sm" value="<?php echo e($record->account_name); ?>">
        <datalist id="account_name_options">

        </datalist>
      </div>
    </div>    
</div>
        <div class="col-6">

    <div class="row mb-3">
      <label for="colFormLabelSm" class="offset-2 col-sm-3 col-form-label col-form-label-sm">Invoice #</label>
      <div class="col-sm-7 ">
        <input type="text" class="form-control form-control-sm"  id="id" placeholder="Invoice #" value="<?php echo e($record->id); ?>" name="invoice_no">
      </div>
    </div>

<div class="row mb-3">
      <label for="colFormLabelSm" class="offset-2 col-sm-3 col-form-label col-form-label-sm">Manual Invoice #</label>
      <div class="col-sm-7">
        <input type="text" class="form-control form-control-sm"  id="manual_no" name="manual_no" placeholder="Manual No #" value="<?php echo e($record->manual_no); ?>">
      </div>
    </div>

<div class="row mb-3">
      <label for="colFormLabelSm" class="offset-2 col-sm-3 col-form-label col-form-label-sm">Entered By</label>
      <div class="col-sm-7">
        <input type="text" class="form-control form-control-sm" name="entered_by" id="entered_by" placeholder="Entered By" value="<?php echo e($record->entered_by); ?>">
      </div>
    </div>
<div class="row mb-3">
      <label for="colFormLabelSm" class="offset-2 col-sm-3 col-form-label col-form-label-sm">Date</label>
      <div class="col-sm-7">
        <input type="date" class="form-control form-control-sm" name="inv_date" id="date" placeholder="Date" value="<?php echo e($record->inv_date); ?>">
      </div>
    </div>

            
        </div>
    </div>
    <div class="row pt-2 bg-light text-dark">
        <div class="col-12">
            <table class="table table-striped table-bordered">
                <tr>
                    <th style="width:10%;"><small>Item Id</small></td>
                    <th style="width:20%"><small>Item Name</small></td>
                    <th><small>Type</small></td>
                    <th><small>Category</small></td>
                    <th class="text-end"><small>Size</small></td>
                    <th class="text-end"><small>Rate</small></td>
                    <th class="text-end"><small>Quantity</small></td>
                    <th class="text-end"><small>Total</small></td>

                    
                </tr>
                
              
                <tbody id="tbl">
 
                <tr>
                    <td style="width:10%"><input type="text" class="form-control  form-control-sm" id="item_id1" name="item_id1"></td>
                    <td style="width:20%">
                        <input list="item_name_options" id="item_name1"  placeholder="Item Name" autocomplete="off" class="form-control form-control-sm" name="item_name1">
                        <datalist id="item_name_options">
                            <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option data-id="<?php echo e($data->id); ?>" value="<?php echo e($data->item_name); ?>"> 
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </datalist>
                    </td>
                    <td>
                        <input list="item_type_options" id="type1"  placeholder="Type" autocomplete="off" class="form-control form-control-sm" name="type1">
                        <datalist id="item_type_options">
                            <?php $__currentLoopData = $type; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option data-id="<?php echo e($data->id); ?>" value="<?php echo e($data->type); ?>"> 
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </datalist>
                        </td>
                    <td>
                        <input list="item_category_options" id="category1"  placeholder="Category" autocomplete="off" class="form-control form-control-sm" name="category1">
                        <datalist id="item_category_options">
                            <?php $__currentLoopData = $category; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option data-id="<?php echo e($data->id); ?>" value="<?php echo e($data->category); ?>"> 
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </datalist>
                        </td>
                    <td><input type="text" class="form-control form-control-sm text-end" name="size1" id="size1"></td>
                    <td><input type="text" class="form-control form-control-sm text-end" name="rate1" id="rate1"></td>
                    <td><input type="text" class="form-control form-control-sm text-end" name="qty1" id="qty1"></td>
                    <td><input type="text" class="form-control form-control-sm text-end" name="total1" id="total1"></td>
                    
                    
                </tr>
                <?php $__currentLoopData = $record_sub; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sub): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                 
                <tr>
                    <td class="d-none"><input type="number" class="form-control form-control-sm" name="id[]" id="value" value="<?php echo e($sub->id); ?>"></td>
                    <td style="width:10%"><input type="text" class="form-control  form-control-sm" id="item_id1" name="item_id[]" value="<?php echo e($sub->item_id); ?>"></td>
                    <td style="width:20%">
                        <input list="item_name_options" id="item_name1"  placeholder="Item Name" autocomplete="off" class="form-control form-control-sm" name="item_name[]" value="<?php echo e($sub->item_name); ?>">
                        <datalist id="item_name_options">
                            <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option data-id="<?php echo e($data->id); ?>" value="<?php echo e($data->item_name); ?>"> 
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </datalist>
                    </td>
                    <td>
                        <input list="item_type_options" id="type1"  placeholder="Type" autocomplete="off" class="form-control form-control-sm" name="type[]" value="<?php echo e($sub->type); ?>">
                        <datalist id="item_type_options">
                            <?php $__currentLoopData = $type; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option data-id="<?php echo e($data->id); ?>" value="<?php echo e($data->type); ?>"> 
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </datalist>
                        </td>
                    <td>
                        <input list="item_category_options" id="category1"  placeholder="Category" autocomplete="off" class="form-control form-control-sm" name="category[]" value="<?php echo e($sub->category); ?>">
                        <datalist id="item_category_options">
                            <?php $__currentLoopData = $category; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option data-id="<?php echo e($data->id); ?>" value="<?php echo e($data->category); ?>"> 
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </datalist>
                        </td>
                   
                    <td><input type="text" class="form-control form-control-sm" name="size[]" id="value" value="<?php echo e($sub->size); ?>"></td>
                    <td><input type="text" class="form-control form-control-sm rate" name="rate[]" id="rate" value="<?php echo e($sub->rate); ?>" onchange="Calc(this);"></td>
                    <td><input type="text" class="form-control form-control-sm qty" name="qty[]" id="qty" value="<?php echo e($sub->qty); ?>" onchange="Calc(this);"></td>
                    <td><input type="text" class="form-control form-control-sm total" name="total[]" id="total" value="<?php echo e($sub->total); ?>" onchange="Calc(this);"></td>
                    
                    
                    
                    </tr>  
                
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>    
                
                                              <tfoot>
                <tr>
                  <td colspan="7" class="text-end">Invoice Amount</td>
                  <td><input type="text" id="FTotal" name="total_amount" class="form-control form-control-sm text-end" value="<?php echo e($record->total_amount); ?>"></td>
                </tr>
              </tfoot>  
            </table>
            

        </div>
    </div>

        
    <button type="button" id="savebtn" class="btn btn-sm btn-success" style="width:15%;">Update Record</button>
    <a href="/Purchase/index" class="btn btn-sm btn-info" style="width:15%;">Close Record</a>

	</form>
    </div>
    

	
</div>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.1/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-ka7Sk0Gln4gmtz2MlQnikT1wXgYsOg+OMhuP+IlRH9sENBO0LRn5q+8nbTov4+1p" crossorigin="anonymous"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/3.5.0/select2.min.js"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/toastify-js"></script>
    
<script>


    var spinner = '<div class="spinner-border" role="status"> <span class="sr-only">Loading...</span></div> &nbsp; Wait...';


$("#total1").focusout(function(){
  addStudent();
});

    $('#savebtn').click(function(){
    
    var lastid = $('#id').val();
    
    
    console.log(lastid);
    if (lastid === null ){
        
        return;
    }
    
    
    var form = $('#invoice')[0];
    var formdata = new FormData(form);

    
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

    $.ajax({
                
                url: '<?php echo e(url("/Purchase/update")); ?>' +'/'+lastid,
                type: 'POST',
                processData: false, contentType: false,
                data: formdata,

                success: function(result){
                                       console.log(result);
                    
                            
                            $('#savebtn').text('Update Record');
                                Toastify({ text: "Update Successfully !", duration: 3000, gravity: "bottom", // `top` or `bottom`
  position: "right", // `left`, `center` or `right`
        style: { background: "linear-gradient(to right, #00b09b, #96c93d)" }
    }).showToast();
                            

                },
                error: function(error){
                    console.log(error)
                    
                    $('#savebtn').text('Update Record');
                                            Toastify({ text: "Sorry Could Not Save !", duration: 3000, gravity: "bottom", // `top` or `bottom`
  position: "right", // `left`, `center` or `right`
        style: { background: "linear-gradient(to right, #B32A0C, #F87255)" }
    }).showToast();

                    
                }
            });


});

    function addStudent(){ 
         
        var item_id= document.getElementById("item_id1").value;
        var item_name= document.getElementById("item_name1").value;
        var type= document.getElementById("type1").value;
        var category= document.getElementById("category1").value;
        var size= document.getElementById("size1").value;
        var rate= document.getElementById("rate1").value;
        var qty= document.getElementById("qty1").value;
        var total= document.getElementById("total1").value;
        
        var tr = document.createElement('tr');
        
        var td1 = tr.appendChild(document.createElement('td'));
        var td2 = tr.appendChild(document.createElement('td'));
        var td3 = tr.appendChild(document.createElement('td'));
        var td4 = tr.appendChild(document.createElement('td'));
        var td5 = tr.appendChild(document.createElement('td'));
        var td6 = tr.appendChild(document.createElement('td'));
        var td7 = tr.appendChild(document.createElement('td'));
        var td8 = tr.appendChild(document.createElement('td'));
        
        
        
        
        
        td1.innerHTML='<input type="text" class="form-control form-control-sm" name="item_id[]" id="item_id" value="' + item_id + '"></td>' ;
        td2.innerHTML='<input type="text" class="form-control form-control-sm" name="item_name[]" id="item_name" value="' + item_name + '"></td>' ;
        td3.innerHTML='<input type="text" class="form-control form-control-sm" name="type[]" id="type" value="' + type + '"></td>' ;
        td4.innerHTML='<input type="text" class="form-control form-control-sm" name="category[]" id="category" value="' + category + '"></td>' ;
        td5.innerHTML='<input type="text" class="form-control  form-control-sm text-end" name="size[]" id="size" value="' + size + '"></td>' ;
        td6.innerHTML='<input type="text" class="form-control form-control-sm text-end rate" name="rate[]" id="rate" value="' + rate + '" onchange="Calc(this);"></td>';
        td7.innerHTML='<input type="text" class="form-control form-control-sm text-end qty" name="qty[]" id="qty" value="' + qty + '" onchange="Calc(this);"></td>';
        td8.innerHTML='<input type="text" class="form-control form-control-sm text-end total" name="total[]" id="total" value="' + total + '" onchange="Calc(this);"></td>';
        
        

        document.getElementById("tbl").appendChild(tr);
        GetTotal();
        clear();
        
    }

    function delStudent(v){
        $(v).parent().parent().remove();
        s.parentNode.removeChild(s);
        GetTotal();
        
    }

    $("#project_name").on('change', function () {
        
    $("#account_name_options").empty();
    
    var value = $('#project_name').val();
    projectid = $('#project_name_options [value="' + value + '"]').data('id');
    $('#project_id').val( projectid );
    
    
            $.ajax({
                url: '<?php echo e(route("Cvoucher.fetchVendors")); ?>',
                type: 'POST',
                data: 'projectid='+projectid+'&_token=<?php echo e(csrf_token()); ?>',
    
                success:function(result){
                       
                        $.each(result.accounts, function (key, value) {
                            $("#account_name_options").append('<option data-headercode="' + value.header_code + '" data-accountid="' + value.id + '" value="' + value.account_name + '">' +  value.account_name  +  '</option>');
                        });                        
    
                }
    
            });  
    
    
    
    });
    
    $("#account_name").on('change', function () {
    
    
    var value = $('#account_name').val();
    accountid = $('#account_name_options [value="' + value + '"]').data('accountid');
    headercode = $('#account_name_options [value="' + value + '"]').data('headercode');
    
    $('#header_code').val( headercode );
    $('#account_id').val( accountid );
    
    });
    
    $("#item_name1").on('change', function () {
    
    
    var value = $('#item_name1').val();
    item_id = $('#item_name_options [value="' + value + '"]').data('id');
    
    $('#item_id1').val( item_id );
    
    });

    $("#rate1").on('change', function () {
     RowTotal();
    });

    $("#qty1").on('change', function () {
     RowTotal();
    });

    function RowTotal(){
        
        var rate1= document.getElementById("rate1").value;
        var qty1= document.getElementById("qty1").value;
        var tot1 = rate1 * qty1;
        
        
        $('#total1').val( tot1 );
        
    }
    
    function clear(){
        $('#total1').val( 0 );
        $('#rate1').val( 0 );
        $('#qty1').val( 0 );
        $('#item_id1').val( 0 );
        $('#item_name1').val( '' );
        $('#type1').val( '' );
        $('#category1').val( '' );
        $('#size1').val( 0 );
        
    }
    
    function Calc(v){
    
    var index = $(v).parent().parent().index()-1;

    qty = document.getElementsByClassName("qty")[index].value;
    rate = document.getElementsByClassName("rate")[index].value;
    
    var amt = qty * rate;
    document.getElementsByClassName("total")[index].value = amt;
    GetTotal();
    


    
}

    function GetTotal()
    {
        /*Footer Calculation*/   
    
        var sum=0;
        var amts =  document.getElementsByClassName("total");
    
        for (let index = 0; index < amts.length; index++)
        {
            var amt = amts[index].value;
            sum = +(sum) +  +(amt) ; 
        }
    
        document.getElementById("FTotal").value = sum;
    

    
    }




    $("input,select").bind("keydown", function(event) {
    if (event.which === 13) {
        event.stopPropagation();
        event.preventDefault();
       $(':input:eq(' + ($(':input').index(this) + 1) +')').focus();
    }
});

</script>

</body>
</html>
    
<?php /**PATH /home/alameenb/public_html/resources/views/Purchase/edit.blade.php ENDPATH**/ ?>