<!doctype html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Imagination Invoice Example</title>
    <!-- For Bootstrap-->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-rbsA2VBKQhggwzxH7pPCaAqO46MgnOM80zW1RWuH61DGLwZJEdK2Kadq2F9CUG65" crossorigin="anonymous">
    <style>
        .input-group-text {
           width: 85px;
        }  
     
    </style>
    <!-- CSS For Print Format -->
    <link rel="stylesheet" media="print" href="invoiceprint.css">
    
    <!-- CSS For Invoice -->
    <link rel="stylesheet"  href="invoice.css">

    <!-- jQuery CDN -->
    <script src="https://code.jquery.com/jquery-3.6.2.slim.js" integrity="sha256-OflJKW8Z8amEUuCaflBZJ4GOg4+JnNh9JdVfoV+6biw=" crossorigin="anonymous"></script>
    
    <!-- For Invoice  -->
    <script src="invoice.js"></script>


</head>
  <body>
    

    <div class="container ">
       

        <div class="card">
            <div class="card-header text-center">
              <h4>INVOICE</h4>
            </div>
            <div class="card-body">
            
                <form action="<?php echo e(url('/invoice/update')); ?>/<?php echo e($invoice->id); ?>" method="post">
                <?php echo csrf_field(); ?>
                <div class="row">
                    <div class="col-8">
                        
                        <div class="input-group mb-3">
                              <span class="input-group-text d-print-none" >Project Id</span>
                              <input type="text" class="form-control d-print-none" value ="<?php echo e($invoice->project_id); ?>" id="project_id" name="project_id" >
                              <span class="input-group-text d-print-none" >Project</span>
                                <select class="form-control rounded-0 d-print-none"  id="project_name" name="project_name" >
                                <option value="<?php echo e($invoice->project_name); ?>"><?php echo e($invoice->project_name); ?></option>
                                <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>   
                                    <option data-id="<?php echo e($data->id); ?>" value="<?php echo e($data->project_name); ?>"><?php echo e($data->project_name); ?></option> 
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        
                         <div class="input-group mb-3">
                            <span class="input-group-text" >Acc-Code</span>
                              <input type="text" class="form-control"  value="<?php echo e($invoice->header_code); ?>" id="header_code" name="header_code">
                              <input type="text" class="form-control" value="<?php echo e($invoice->account_id); ?>" id="account_id" name="account_id" >
                        </div>
                        <div class="input-group mb-3">
                             
                            <span class="input-group-text" >Customer</span>
                            <select class="form-control rounded-0" id="account_name" name="account_name" >
                                <option value="<?php echo e($invoice->account_name); ?>"><?php echo e($invoice->account_name); ?></option>
                                <?php $__currentLoopData = $accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>   
                                    <option data-header_code="<?php echo e($data->header_code); ?>"  data-id="<?php echo e($data->id); ?>" value="<?php echo e($data->account_name); ?>"><?php echo e($data->account_name); ?></option> 
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
            
            
                        <div class="input-group mb-3">
                            <span class="input-group-text" >City</span>
                            <input type="text" class="form-control" name="city" placeholder="City"  value="<?php echo e($invoice->city); ?>">
                        </div>
                    </div>
                    <div class="col-4">
                      
                        <div class="input-group mb-3">
                            <span class="input-group-text" >Inv. No</span>
                            <input type="text" class="form-control" placeholder="Inv. No"  name="inv_id" value="<?php echo e($invoice->id); ?>">
                        </div>

                        <div class="input-group mb-3">
                            <span class="input-group-text" >Inv. Date</span>
                            <input type="date" class="form-control" name="inv_date" placeholder="Inv. Date"  value="<?php if(isset($invoice->inv_date)): ?><?php echo e($invoice->inv_date); ?><?php else: ?> <?php echo e(now()->format('Y-m-d')); ?> <?php endif; ?>">
                        </div>



                    </div>
                </div>
                <table class="table table-bordered">
                    <thead class="table-success">
                      <tr>
                        <th scope="col">#</th>
                        <th scope="col">Items</th>
                        <th scope="col" class="text-end">Qty</th>
                        <th scope="col" class="text-end">Rate</th>
                        <th scope="col" class="text-end d-print-none">PurPrice</th>
                        <th scope="col" class="text-end">Amount</th>
                        <th scope="col">                         
                            <button type="button" class="btn btn-sm btn-success d-print-none" onclick="BtnAdd()">+</button>
                        </th>

                      </tr>
                    </thead>
                    <tbody id="TBody">
                        
                        <?php $__currentLoopData = $invoice_sub; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        
                        
                          <tr id="TRow">
                            <th scope="row"><?php echo e($loop->iteration); ?></th>
                            
                            <input type="hidden" class="form-control" value="<?php echo e($data->id); ?>" name="id[]">
                            <td><input type="text" class="form-control" value="<?php echo e($data->item_name); ?>" name="item_name[]"></td>
                            <td><input type="number" class="form-control text-end qty" value="<?php echo e($data->qty); ?>" id="qty" name="qty[]" onchange="Calc(this);"></td>
                            <td><input type="number" class="form-control text-end rate" value="<?php echo e($data->rate); ?>" id="rate" name="rate[]"  onchange="Calc(this);"></td>
                            <td><input type="number" class="form-control text-end pur_price d-print-none" value="<?php echo e($data->pur_price); ?>" id="pur_price" value="0" name="pur_price[]"  onchange="Calc(this);"></td>
                            <td><input type="number" class="form-control text-end amt" value="<?php echo e($data->rate*$data->qty); ?>" name="amt" value="0" disabled=""></td>
                            <td><button type="button" class="btn btn-sm btn-danger d-print-none" onclick="BtnDel(this)">X</button></td>
                          </tr>
                          
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      
                    </tbody>
                  </table>
                  <div class="row">
                    <div class="col-8">
                      
                        
                        <button type="submit" class="btn btn-info d-print-none" >Update</button>

                    </div>
                    <div class="col-4">
                        <div class="input-group mb-3">
                            <span class="input-group-text" >Total</span>
                            <input type="number" class="form-control text-end" id="FTotal" name="FTotal" disabled="">
                        </div>
                        <div class="input-group mb-3">
                            <span class="input-group-text" >GST</span>
                            <input type="number" class="form-control text-end" id="FGST" name="FGST" onchange="GetTotal()">
                        </div>
                        <div class="input-group mb-3">
                            <span class="input-group-text" >Net Amt</span>
                            <input type="number" class="form-control text-end" id="FNet" name="FNet">
                        </div>


                    </div>
                </div>
            </form>
             </div>
          </div>

    </div>



    <!-- Bootstrap Bundle JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-kenU1KFdBIe4zVF0s0G1M5b4hcpxyD9F7jL+jjXkk+Q2h455rYXK/7HAuoJl+0I4" crossorigin="anonymous"></script>
    
    <script>
   
    
        $('#project_name').change(function(){
    
        
         var selected = $(this).find('option:selected');    
         var project_id = selected.data('id');
         $('#project_id').val( project_id );
    
    
        
        });
    
        $('#account_name').change(function(){

        var selected = $(this).find('option:selected');
        var header_code = selected.data('header_code');
        $('#header_code').val( header_code );
        
         var selected = $(this).find('option:selected');
        var account_id = selected.data('id');
        $('#account_id').val( account_id );       
        
    
        });

  
    </script>
    
    <script>
    

   
         
        GetTotal();
        
        function GetPrint()
        {
            /*For Print*/
            window.print();
        }
        
        function BtnAdd()
        {
            
            /*Add Button*/
            var v = $("#TRow").clone().appendTo("#TBody") ;
            $(v).find("input").val('');
            $(v).removeClass("d-none");

            $(v).find("th").first().html($('#TBody tr').length - 1);
        }
        
        function BtnDel(v)
        {
            /*Delete Button*/
               $(v).parent().parent().remove(); 
               GetTotal();
        
                $("#TBody").find("tr").each(
                function(index)
                {
                   $(this).find("th").first().html(index);
                }
        
               );
        }
        
        function Calc(v)
        {
                            /*Detail Calculation Each Row*/
            var index = $(v).parent().parent().index();
            
            var rate = document.getElementsByClassName("rate")[index].value;
            var qty = document.getElementsByClassName("qty")[index].value;
            
            var amt = qty * rate;
          
            
            document.getElementsByClassName("amt")[index].value = amt;
           
        
            GetTotal();

        }
        
        function GetTotal()
        {
            /*Footer Calculation*/   
        
            var sum=0;
            var amts =  document.getElementsByClassName("amt");
        
            for (let index = 0; index < amts.length; index++)
            {
                var amt = amts[index].value;
                sum = +(sum) +  +(amt) ; 
            }
        
            document.getElementById("FTotal").value = sum;
        
            var gst =  document.getElementById("FGST").value;
            var net = +(sum) + +(gst);
            document.getElementById("FNet").value = net;
        
        }


    </script>
  </body>
</html><?php /**PATH /home/imtiazir/public_html/resources/views//invoice/edit.blade.php ENDPATH**/ ?>